

if "%VSCMD_DEBUG%" GEQ "1" @echo [DEBUG:core\%~n0] initializing with arguments '%*'

@REM skip to end if -help (-?) were specified
if "%VSCMD_ARG_HELP%" NEQ "" goto :end

@REM If both -test and -clean_env are specified, -clean_env should be ignored.
if "%VSCMD_TEST%" NEQ "" (
    endlocal
    goto :end
)
if "%VSCMD_ARG_CLEAN_ENV%" NEQ "" goto :clean_env

@REM Set the current directory that users will be set after the script completes
@REM in the following order:
@REM 1. [VSCMD_START_DIR] will be used if specified in the user environment
@REM 2. [USERPROFILE]\source if it exists
@REM 3. current directory
if "%VSCMD_START_DIR%" NEQ "" (
    cd /d "%VSCMD_START_DIR%"
) else (
    if EXIST "%USERPROFILE%\Source" (
        cd /d "%USERPROFILE%\Source"
    )
)

goto :end

@REM ------------------------------------------------------------------------
:clean_env

set DevEnvDir=
set VSINSTALLDIR=
set VSCMD_VER=

@REM restore old PATH, INCLUDE, LIB, and LIBPATH if they were
@REM saved prior to execution of the VSDevCmd scripts.
if not "%__VSCMD_PREINIT_PATH%"=="" set "PATH=%__VSCMD_PREINIT_PATH%"
if not "%__VSCMD_PREINIT_INCLUDE%"=="" (
    set "INCLUDE=%__VSCMD_PREINIT_INCLUDE%"
) else (
    set INCLUDE=
)
if not "%__VSCMD_PREINIT_LIB%"=="" (
    set "LIB=%__VSCMD_PREINIT_LIB%"
) else (
    set LIB=
)
if not "%__VSCMD_PREINIT_LIBPATH%"=="" (
    set "LIBPATH=%__VSCMD_PREINIT_LIBPATH%"
) else (
    set LIBPATH=
)

@REM clean up the variables that would be set due to command line args
call "%~dp0parse_cmd.bat"

@REM Restore the "classic installer" VS150COMNTOOLS value, if it was set prior
@REM to command prompt init.
if "%__VSCMD_PREINIT_VS150COMNTOOLS%" NEQ "" (
    set "VS150COMNTOOLS=%__VSCMD_PREINIT_VS150COMNTOOLS%"
) else (
    set VS150COMNTOOLS=
)

set __VSCMD_PREINIT_PATH=
set __VSCMD_PREINIT_INCLUDE=
set __VSCMD_PREINIT_LIB=
set __VSCMD_PREINIT_LIBPATH=
set __VSCMD_PREINIT_VS150COMNTOOLS=

@REM Dump then environment after clean-up of ENV scripts.  This is used
@REM for testing to ensure that the pre-init environment can be successfully
@REM restored via -clean_env.
@REM
@REM Note: This mechanism depends on the __VSCMD_PREINIT_* variables having
@REM successfully captured the pre-initialization values AND individual
@REM component scripts having correctly implemented -clean_env functionality
@REM for the variables they set. If end-users further customize the
@REM environment, those settings many not be cleaned-up correctly.
if "%VSCMD_DEBUG%" NEQ "" (
    @echo [DEBUG:%~n0] Writing post-clean environment to %temp%\dd_vsdevcmd15_postclean_env.log
    set > "%temp%\dd_vsdevcmd15_postclean_env.log"
)

goto :end

@REM ------------------------------------------------------------------------
:end
set VSCMD_TEST=
set VSCMD_ARG_HELP=
set VSCMD_ERR=